/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import cafeloader.RplConverter;
import cafeloader.RplHeader;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.elf.ElfException;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.ElfLoader;
import ghidra.app.util.opinion.ElfProgramBuilder;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.zip.DataFormatException;

public class CafeLoader
extends ElfLoader {
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        byte[] header = new byte[]{127, 69, 76, 70, 1, 2, 1, -54, -2};
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (Arrays.equals(provider.readBytes(0L, (long)header.length), header)) {
            List results = QueryOpinionService.query((String)this.getName(), (String)"wiiu", null);
            boolean hasGekkoProcessor = false;
            for (QueryResult result : results) {
                if (!result.pair.languageID.getIdAsString().contains("Gekko")) continue;
                hasGekkoProcessor = true;
            }
            for (QueryResult result : results) {
                if (result.pair.languageID.getIdAsString().contains("Gekko")) {
                    loadSpecs.add(new LoadSpec((Loader)this, 0L, new QueryResult(result.pair, true)));
                    continue;
                }
                loadSpecs.add(new LoadSpec((Loader)this, 0L, new QueryResult(result.pair, hasGekkoProcessor ? false : result.preferred)));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, new LanguageCompilerSpecPair("PowerPC:BE:32:default", "default"), true));
            }
        }
        return loadSpecs;
    }

    public String getName() {
        return "Wii U / CafeOS Binary (RPX/RPL)";
    }

    public LoaderTier getTier() {
        return LoaderTier.SPECIALIZED_TARGET_LOADER;
    }

    public int getTierPriority() {
        return 0;
    }

    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        try {
            byte[] data = RplConverter.convertRpl(provider, arg_0 -> ((MessageLog)log).appendMsg(arg_0));
            RplHeader rpl = new RplHeader((ByteProvider)new ByteArrayProvider(data), arg_0 -> ((MessageLog)log).appendMsg(arg_0));
            ElfProgramBuilder.loadElf((ElfHeader)rpl, (Program)program, options, (MessageLog)log, (TaskMonitor)monitor);
        }
        catch (ElfException | DataFormatException var8) {
            throw new IOException(var8.getMessage());
        }
    }
}

