/*
 * Decompiled with CFR 0.152.
 */
package cafeloader;

import cafeloader.Cafe_ElfExtension;
import cafeloader.RplHeader;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.elf.ElfConstants;
import ghidra.app.util.bin.format.elf.ElfException;
import ghidra.app.util.bin.format.elf.RplSectionHeader;
import ghidra.util.BigEndianDataConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class RplConverter {
    public static final int SHF_RPL_ZLIB = 0x8000000;
    public static final int SHT_RPL_EXPORTS = -2147483647;
    public static final int SHT_RPL_IMPORTS = -2147483646;
    public static final int SHT_RPL_CRCS = -2147483645;
    public static final int SHT_RPL_FILEINFO = -2147483644;
    public static final byte ELFOSABI_CAFE = -54;
    public static final byte ELFOSABI_VERSION_CAFE = -2;

    public static byte[] convertRpl(ByteProvider byteProvider, Consumer<String> errorConsumer) throws ElfException, IOException, DataFormatException {
        RplHeader elfHeader = new RplHeader(byteProvider, errorConsumer);
        BinaryReader reader = elfHeader.getReader();
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)byteProvider.length());
        BigEndianDataConverter dc = BigEndianDataConverter.INSTANCE;
        out.write(ElfConstants.MAGIC_BYTES);
        out.write(1);
        out.write(2);
        out.write(1);
        out.write(-54);
        out.write(-2);
        out.write(new byte[7]);
        out.write(dc.getBytes(elfHeader.e_type()));
        out.write(dc.getBytes(elfHeader.e_machine()));
        out.write(dc.getBytes(elfHeader.e_version()));
        out.write(dc.getBytes((int)elfHeader.e_entry()));
        out.write(dc.getBytes(0));
        out.write(dc.getBytes(64));
        out.write(dc.getBytes(elfHeader.e_flags()));
        out.write(dc.getBytes(elfHeader.e_ehsize()));
        out.write(dc.getBytes((short)0));
        out.write(dc.getBytes((short)0));
        out.write(dc.getBytes(elfHeader.e_shentsize()));
        out.write(dc.getBytes((short)elfHeader.getSectionHeaderCount()));
        out.write(dc.getBytes((short)elfHeader.e_shstrndx()));
        out.write(new byte[12]);
        long sectionDataOffset = elfHeader.e_shoff() + (long)elfHeader.getSectionHeaderCount() * (long)elfHeader.e_shentsize();
        ByteArrayOutputStream sectionData = new ByteArrayOutputStream();
        for (int i = 0; i < elfHeader.getSectionHeaderCount(); ++i) {
            int sectionType;
            long index = elfHeader.e_shoff() + (long)i * (long)elfHeader.e_shentsize();
            reader.setPointerIndex(index);
            RplSectionHeader sectionHeader = new RplSectionHeader(reader, elfHeader);
            long size = sectionHeader.getSize();
            reader.setPointerIndex(sectionHeader.getOffset());
            if (sectionHeader.getType() != 8) {
                if ((sectionHeader.getFlags() & 0x8000000L) == 0x8000000L) {
                    size = reader.readNextInt();
                    byte[] inflatedData = new byte[(int)size];
                    byte[] deflatedData = reader.readNextByteArray((int)sectionHeader.getSize() - 4);
                    Inflater inflater = new Inflater();
                    inflater.setInput(deflatedData);
                    inflater.inflate(inflatedData);
                    inflater.end();
                    sectionData.write(inflatedData);
                } else if (size > 0L) {
                    byte[] inflatedData = reader.readNextByteArray((int)size);
                    sectionData.write(inflatedData);
                }
            }
            if ((sectionType = sectionHeader.getType()) == -2147483647) {
                sectionType = Cafe_ElfExtension.SHT_RPL_EXPORTS.value;
            } else if (sectionType == -2147483646) {
                sectionType = Cafe_ElfExtension.SHT_RPL_IMPORTS.value;
            } else if (sectionType == -2147483644) {
                sectionType = Cafe_ElfExtension.SHT_RPL_FILEINFO.value;
            } else if (sectionType == -2147483645) {
                sectionType = Cafe_ElfExtension.SHT_RPL_CRCS.value;
            }
            out.write(dc.getBytes(sectionHeader.getName()));
            out.write(dc.getBytes(sectionType));
            out.write(dc.getBytes((int)sectionHeader.getFlags()));
            out.write(dc.getBytes((int)sectionHeader.getAddress()));
            if (sectionHeader.getType() != 8 && size > 0L) {
                out.write(dc.getBytes((int)sectionDataOffset));
                out.write(dc.getBytes((int)size));
                sectionDataOffset += size;
            } else {
                out.write(dc.getBytes((int)sectionHeader.getOffset()));
                out.write(dc.getBytes((int)sectionHeader.getSize()));
            }
            out.write(dc.getBytes(sectionHeader.getLink()));
            out.write(dc.getBytes(sectionHeader.getInfo()));
            out.write(dc.getBytes((int)sectionHeader.getAddressAlignment()));
            out.write(dc.getBytes((int)sectionHeader.getEntrySize()));
        }
        out.write(sectionData.toByteArray());
        return out.toByteArray();
    }
}

