/*
 * Decompiled with CFR 0.152.
 */
package cafeloader;

import cafeloader.Cafe_ElfExtension;
import cafeloader.RplHeader;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;

public class Cafe_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf instanceof RplHeader;
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        int byteLength;
        int newValue;
        int oldValue;
        int symbolValue;
        int offset;
        int addend;
        Memory memory;
        int type;
        block24: {
            ElfSectionHeader symbolSection;
            type = relocation.getType();
            if (type == 0) {
                return RelocationResult.SKIPPED;
            }
            ElfHeader elf = elfRelocationContext.getElfHeader();
            Program program = elfRelocationContext.getProgram();
            memory = program.getMemory();
            int symbolIndex = relocation.getSymbolIndex();
            addend = (int)relocation.getAddend();
            offset = (int)relocationAddress.getOffset();
            ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
            symbolValue = (int)elfRelocationContext.getSymbolValue(sym);
            oldValue = memory.getInt(relocationAddress);
            newValue = 0;
            byteLength = 4;
            if (sym.getSectionHeaderIndex() > 0 && (symbolSection = elf.getSections()[sym.getSectionHeaderIndex()]).getType() == Cafe_ElfExtension.SHT_RPL_IMPORTS.value) {
                ExternalLocation location;
                String symbolSectionName = symbolSection.getNameAsString();
                boolean isDataImport = false;
                if (symbolSectionName.startsWith(".dimport_")) {
                    program.getReferenceManager().addMemoryReference(relocationAddress, elfRelocationContext.getSymbolAddress(sym), RefType.DATA, SourceType.IMPORTED, 0);
                    isDataImport = true;
                } else if (symbolSectionName.startsWith(".fimport_")) {
                    program.getReferenceManager().addMemoryReference(relocationAddress, elfRelocationContext.getSymbolAddress(sym), (RefType)RefType.UNCONDITIONAL_CALL, SourceType.IMPORTED, 0);
                }
                Object rplName = symbolSectionName.split("import_")[1];
                if (!((String)rplName).endsWith(".rpl")) {
                    rplName = (String)rplName + ".rpl";
                }
                if ((location = program.getExternalManager().getUniqueExternalLocation((String)rplName, sym.getNameAsString())) != null) {
                    try {
                        if (isDataImport) {
                            program.getReferenceManager().addExternalReference(relocationAddress, 1, location, SourceType.IMPORTED, RefType.DATA);
                            break block24;
                        }
                        program.getReferenceManager().addExternalReference(relocationAddress, 1, location, SourceType.IMPORTED, (RefType)RefType.UNCONDITIONAL_CALL);
                    }
                    catch (InvalidInputException e) {
                        Msg.warn((Object)((Object)this), (Object)("addExternalReference failed with " + e));
                    }
                } else {
                    Msg.warn((Object)((Object)this), (Object)("Failed to find location for " + sym.getNameAsString()));
                }
            }
        }
        switch (type) {
            case 1: {
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 4: {
                newValue = symbolValue + addend;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 5: {
                newValue = symbolValue + addend >> 16;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 6: {
                newValue = symbolValue + addend + 32768 >> 16;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 10: {
                newValue = symbolValue + addend - offset >> 2;
                newValue = newValue << 2 & 0x3FFFFFC;
                newValue = oldValue & 0xFC000003 | newValue;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 11: {
                newValue = symbolValue + addend - offset >> 2;
                newValue = oldValue & 0xFFDF0003 | newValue << 2 & 0x20FFFC;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 251: {
                newValue = symbolValue + addend - offset + 32768 >> 16;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 252: {
                newValue = symbolValue + addend - offset >> 16;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 253: {
                newValue = symbolValue + addend - offset;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case 78: {
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 68: {
                memory.setInt(relocationAddress, 0);
                break;
            }
            default: {
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

