/*
 * Decompiled with CFR 0.152.
 */
package cafeloader;

import cafeloader.RplHeader;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeaderType;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;

public class Cafe_ElfExtension
extends ElfExtension {
    public static final ElfSectionHeaderType SHT_RPL_EXPORTS = new ElfSectionHeaderType(212852737, "SHT_RPL_EXPORTS", "Section contains RPL exports");
    public static final ElfSectionHeaderType SHT_RPL_IMPORTS = new ElfSectionHeaderType(212852738, "SHT_RPL_IMPORTS", "Section contains RPL imports");
    public static final ElfSectionHeaderType SHT_RPL_CRCS = new ElfSectionHeaderType(212852739, "SHT_RPL_CRCS", "Section contains RPL crcs");
    public static final ElfSectionHeaderType SHT_RPL_FILEINFO = new ElfSectionHeaderType(212852740, "SHT_RPL_FILEINFO", "Section contains RPL file info");
    public static final int RPL_FILEINFO_V3 = -889322752;
    public static final int RPL_FILEINFO_V4_1 = -889322495;
    public static final int RPL_FILEINFO_V4_2 = -889322494;

    public boolean canHandle(ElfHeader elf) {
        return elf instanceof RplHeader;
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        return this.canHandle(elfLoadHelper.getElfHeader());
    }

    public String getDataTypeSuffix() {
        return "_PPC";
    }

    public Address evaluateElfSymbol(ElfLoadHelper elfLoadHelper, ElfSymbol elfSymbol, Address address, boolean isExternal) {
        ElfHeader elf = elfLoadHelper.getElfHeader();
        ElfSectionHeader section = elf.getSections()[elfSymbol.getSectionHeaderIndex()];
        if (section.getType() != Cafe_ElfExtension.SHT_RPL_IMPORTS.value) {
            return address;
        }
        String name = elfSymbol.getNameAsString();
        if (name == null) {
            return address;
        }
        if (!elfSymbol.isFunction() && !elfSymbol.isObject()) {
            return address;
        }
        String sectionName = section.getNameAsString();
        if (!sectionName.startsWith(".fimport_") && !sectionName.startsWith(".dimport_")) {
            return address;
        }
        Object rplName = sectionName.split("import_")[1];
        if (!((String)rplName).endsWith(".rpl")) {
            rplName = (String)rplName + ".rpl";
        }
        try {
            Program program = elfLoadHelper.getProgram();
            elfLoadHelper.setElfSymbolAddress(elfSymbol, address);
            elfLoadHelper.createSymbol(address, name, true, elfSymbol.isAbsolute(), null);
            if (elfSymbol.isFunction()) {
                program.getExternalManager().addExtFunction((String)rplName, name, null, SourceType.IMPORTED);
            } else if (elfSymbol.isObject()) {
                program.getExternalManager().addExtLocation((String)rplName, name, null, SourceType.IMPORTED);
            }
            return null;
        }
        catch (InvalidInputException invalidInputException) {
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        return address;
    }

    public Boolean isSectionWritable(ElfSectionHeader section) {
        String name = section.getNameAsString();
        if (name != null && name.contentEquals(".rodata")) {
            return false;
        }
        if (name != null && name.startsWith(".dimport")) {
            return true;
        }
        return (section.getFlags() & 1L) != 0L;
    }

    public void processElf(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        ElfHeader elf = elfLoadHelper.getElfHeader();
        for (ElfSectionHeader sectionHeader : elf.getSections()) {
            int headertype = sectionHeader.getType();
            if (headertype == Cafe_ElfExtension.SHT_RPL_CRCS.value) {
                this.processRplCrcs(elfLoadHelper, sectionHeader);
                continue;
            }
            if (headertype == Cafe_ElfExtension.SHT_RPL_FILEINFO.value) {
                this.processRplFileInfo(elfLoadHelper, sectionHeader);
                continue;
            }
            if (headertype == Cafe_ElfExtension.SHT_RPL_IMPORTS.value) {
                this.processRplImports(elfLoadHelper, sectionHeader);
                continue;
            }
            if (headertype != Cafe_ElfExtension.SHT_RPL_EXPORTS.value) continue;
            this.processRplExports(elfLoadHelper, sectionHeader);
        }
    }

    private void processRplImports(ElfLoadHelper elfLoadHelper, ElfSectionHeader sectionHeader) {
        Address sectionAddress = elfLoadHelper.findLoadAddress((MemoryLoadable)sectionHeader, 0L);
        int sectionSize = (int)sectionHeader.getSize();
        elfLoadHelper.createUndefinedData(sectionAddress, sectionSize);
        byte[] zeroes = new byte[sectionSize];
        try {
            elfLoadHelper.getProgram().getMemory().setBytes(sectionAddress, zeroes);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
    }

    private void processRplExports(ElfLoadHelper elfLoadHelper, ElfSectionHeader sectionHeader) {
        String sectionName = sectionHeader.getNameAsString();
        if (sectionName.contentEquals(".dexports")) {
            BinaryReader reader = elfLoadHelper.getElfHeader().getReader();
            reader.setPointerIndex(sectionHeader.getOffset());
            try {
                int count = reader.readNextInt();
                reader.readNextInt();
                for (int i = 0; i < count; ++i) {
                    int value = reader.readNextInt();
                    int nameOffset = reader.readNextInt();
                    String name = reader.readAsciiString(sectionHeader.getOffset() + (long)(nameOffset & Integer.MAX_VALUE));
                    elfLoadHelper.createSymbol(elfLoadHelper.getDefaultAddress((long)value), name, true, false, null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InvalidInputException e) {
                e.printStackTrace();
            }
        }
        Address sectionAddress = elfLoadHelper.findLoadAddress((MemoryLoadable)sectionHeader, 0L);
        int sectionSize = (int)sectionHeader.getSize();
        elfLoadHelper.createUndefinedData(sectionAddress, sectionSize);
        byte[] zeroes = new byte[sectionSize];
        try {
            elfLoadHelper.getProgram().getMemory().setBytes(sectionAddress, zeroes);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
    }

    private void processRplCrcs(ElfLoadHelper elfLoadHelper, ElfSectionHeader sectionHeader) {
        Address address = elfLoadHelper.findLoadAddress((MemoryLoadable)sectionHeader, 0L);
        if (address == null) {
            return;
        }
        try {
            for (long i = 0L; i < sectionHeader.getSize(); i += 4L) {
                elfLoadHelper.createData(address.add(i), (DataType)DWordDataType.dataType);
            }
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
    }

    private void processRplFileInfo(ElfLoadHelper elfLoadHelper, ElfSectionHeader sectionHeader) {
        Address fileInfoAddr = elfLoadHelper.findLoadAddress((MemoryLoadable)sectionHeader, 0L);
        if (fileInfoAddr == null) {
            return;
        }
        int version = -889322752;
        Program program = elfLoadHelper.getProgram();
        Memory memory = program.getMemory();
        try {
            version = memory.getInt(fileInfoAddr);
        }
        catch (MemoryAccessException e) {
            Msg.warn((Object)((Object)this), (Object)"Failed to read RplFileInfo version");
        }
        StructureDataType fileInfo = new StructureDataType(new CategoryPath("/ELF"), "Elf32_RplFileInfo", 0);
        int filenameOffset = 0;
        int sdaBase = 0;
        int sda2Base = 0;
        if (version >= -889322752) {
            fileInfo.add((DataType)DWordDataType.dataType, "version", null);
            fileInfo.add((DataType)DWordDataType.dataType, "textSize", null);
            fileInfo.add((DataType)DWordDataType.dataType, "textAlign", null);
            fileInfo.add((DataType)DWordDataType.dataType, "dataSize", null);
            fileInfo.add((DataType)DWordDataType.dataType, "dataAlign", null);
            fileInfo.add((DataType)DWordDataType.dataType, "loadSize", null);
            fileInfo.add((DataType)DWordDataType.dataType, "loadAlign", null);
            fileInfo.add((DataType)DWordDataType.dataType, "tempSize", null);
            fileInfo.add((DataType)DWordDataType.dataType, "trampAdjust", null);
            fileInfo.add((DataType)DWordDataType.dataType, "sdaBase", null);
            fileInfo.add((DataType)DWordDataType.dataType, "sda2Base", null);
            fileInfo.add((DataType)DWordDataType.dataType, "stackSize", null);
            fileInfo.add((DataType)DWordDataType.dataType, "filenameOffset", null);
            try {
                sdaBase = memory.getInt(fileInfoAddr.add(36L));
                sda2Base = memory.getInt(fileInfoAddr.add(40L));
                filenameOffset = memory.getInt(fileInfoAddr.add(48L));
            }
            catch (MemoryAccessException e) {
                Msg.warn((Object)((Object)this), (Object)"Failed to read filenameOffset");
            }
        }
        Address minAddress = program.getAddressFactory().getDefaultAddressSpace().getMinAddress();
        Address maxAddress = program.getAddressFactory().getDefaultAddressSpace().getMaxAddress();
        if (sdaBase != 0 && minAddress != null && maxAddress != null) {
            Register r13 = elfLoadHelper.getProgram().getRegister("r13");
            try {
                program.getProgramContext().setValue(r13, minAddress, maxAddress, BigInteger.valueOf(sdaBase));
            }
            catch (ContextChangeException e) {
                Msg.warn((Object)((Object)this), (Object)("Error setting r13 to sdabase: " + e));
            }
        }
        if (sda2Base != 0 && minAddress != null && maxAddress != null) {
            Register r2 = elfLoadHelper.getProgram().getRegister("r2");
            try {
                program.getProgramContext().setValue(r2, minAddress, maxAddress, BigInteger.valueOf(sda2Base));
            }
            catch (ContextChangeException e) {
                Msg.warn((Object)((Object)this), (Object)("Error setting r2 to sda2base: " + e));
            }
        }
        int tagOffset = 0;
        if (version >= -889322495) {
            fileInfo.add((DataType)DWordDataType.dataType, "flags", null);
            fileInfo.add((DataType)DWordDataType.dataType, "heapSize", null);
            fileInfo.add((DataType)DWordDataType.dataType, "tagOffset", null);
            try {
                tagOffset = memory.getInt(fileInfoAddr.add(60L));
            }
            catch (MemoryAccessException e) {
                Msg.warn((Object)((Object)this), (Object)"Failed to read tagOffset");
            }
        }
        if (version >= -889322494) {
            fileInfo.add((DataType)DWordDataType.dataType, "minVersion", null);
            fileInfo.add((DataType)DWordDataType.dataType, "compressionLevel", null);
            fileInfo.add((DataType)DWordDataType.dataType, "trampAddition", null);
            fileInfo.add((DataType)DWordDataType.dataType, "fileInfoPad", null);
            fileInfo.add((DataType)DWordDataType.dataType, "cafeSdkVersion", null);
            fileInfo.add((DataType)DWordDataType.dataType, "cafeSdkRevision", null);
            fileInfo.add((DataType)WordDataType.dataType, "tlsModuleIndex", null);
            fileInfo.add((DataType)WordDataType.dataType, "tlsAlignShift", null);
            fileInfo.add((DataType)DWordDataType.dataType, "runtimeFileInfoSize", null);
        }
        elfLoadHelper.createData(fileInfoAddr, (DataType)fileInfo);
        if (filenameOffset != 0) {
            try {
                elfLoadHelper.createData(fileInfoAddr.add((long)filenameOffset), (DataType)TerminatedStringDataType.dataType);
            }
            catch (AddressOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (tagOffset != 0) {
            try {
                Data d;
                int length;
                Address tagAddress = fileInfoAddr.add((long)tagOffset);
                while ((length = (d = elfLoadHelper.createData(tagAddress, (DataType)TerminatedStringDataType.dataType)).getLength()) != 0) {
                    tagAddress = tagAddress.add((long)length);
                }
            }
            catch (AddressOutOfBoundsException addressOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

